use socle;

CREATE TABLE delivery_note (
    id INT AUTO_INCREMENT PRIMARY KEY,
    provider VARCHAR(255) NOT NULL,
    airport VARCHAR(255) NOT NULL,
    terminal VARCHAR(255) NOT NULL,
    date DATETIME NOT NULL,
    bagsNumber VARCHAR(255) NOT NULL,
    fileId INT NULL,
    createdAt TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
    updatedAt TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
    FOREIGN KEY (fileId) REFERENCES files(id) ON DELETE CASCADE ON UPDATE CASCADE

);

-- Create DeliveryBag table
CREATE TABLE delivery_bag (
    id INT AUTO_INCREMENT PRIMARY KEY,
    ahl VARCHAR(255) NOT NULL,
    passenger VARCHAR(255) NOT NULL,
    address VARCHAR(255) NOT NULL,
    mainPhone VARCHAR(255) NOT NULL,
    secondPhone VARCHAR(255) NULL,
    color VARCHAR(255) NULL,
    route VARCHAR(255) NULL,
    tag VARCHAR(255) NULL,
    ld01 VARCHAR(255) NULL,
    ld02 VARCHAR(255) NULL,
    bagsNumber VARCHAR(255) NULL,
    fileId INT NULL,
    deliveryNotesId INT,
    FOREIGN KEY (deliveryNotesId) REFERENCES delivery_note(id) ON DELETE CASCADE ON UPDATE CASCADE,
    FOREIGN KEY (fileId) REFERENCES files(id) ON DELETE CASCADE ON UPDATE CASCADE
); 